/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.ws.api.IWSTypeEntry;
import filenet.ws.api.WSDefinedElement;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSElementDecl;
import filenet.ws.api.WSMessage;
import filenet.ws.api.WSType;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSMessageSchema {
    static String s_targetNamespace = "targetNamespace";
    static String s_xmlns = "xmlns";
    static String s_xmlnsPrefix = "xmlns:";
    static String s_xsdSchema = "xsd:schema";
    static String s_XMLSchmea = "XMLSchema";
    static String s_schema = "Schema";
    private WSDefinition m_definition = null;
    private Document m_doc = null;
    private Hashtable m_schemaNodes = new Hashtable();
    private String m_targetNamespace = null;
    private Hashtable m_schemas = new Hashtable();

    public WSMessageSchema(WSDefinition definition) {
        this.m_definition = definition;
        if (definition != null) {
            Types types;
            List list;
            this.m_targetNamespace = definition.getTargetNameSpace();
            if (this.m_targetNamespace != null) {
                if (this.m_targetNamespace.lastIndexOf("/") != this.m_targetNamespace.length() - 1) {
                    this.m_targetNamespace = this.m_targetNamespace + "/";
                }
                this.m_targetNamespace = this.m_targetNamespace + s_XMLSchmea;
            }
            if ((list = (types = definition.getDefinition().getTypes()).getExtensibilityElements()) == null) {
                return;
            }
            ListIterator iterator = list.listIterator();
            Object obj = null;
            while (iterator.hasNext()) {
                UnknownExtensibilityElement extElt;
                Element elt;
                obj = iterator.next();
                if (obj == null || !(obj instanceof UnknownExtensibilityElement) || (elt = (extElt = (UnknownExtensibilityElement)obj).getElement()).getNodeName() == null || elt.getLocalName().compareTo("schema") != 0) continue;
                SchemaNode schemaNode = new SchemaNode(elt);
                this.m_schemaNodes.put(schemaNode.getTargetNamespace(), schemaNode);
            }
        }
    }

    public String[] getMessageSchema(WSMessage[] messages) throws Exception {
        return null;
    }

    public String[] getMessageSchema(WSMessage message) throws Exception {
        return null;
    }

    private void addTypeToSchema(WSType type) {
        if (type == null || this.m_doc == null) {
            return;
        }
        if (!type.isBaseType()) {
            Node typeNode = type.getType().getNode();
            SchemaNode schemaNode = this.getSchemaNode(typeNode);
            Schema schema = (Schema)this.m_schemas.get(schemaNode);
            if (schema == null) {
                schema = new Schema(schemaNode);
                this.m_schemas.put(schemaNode, schema);
            }
            schema.addToSchema(type);
        }
    }

    private void addElementToSchema(WSElementDecl element) {
        if (element.getType() != null) {
            this.addTypeToSchema(element.getType());
        }
    }

    private SchemaNode getSchema(Node node) {
        Collection collection;
        if (this.m_schemaNodes != null && (collection = this.m_schemaNodes.values()) != null) {
            Iterator it = collection.iterator();
            Object obj = null;
            while (it.hasNext()) {
                obj = it.next();
                if (obj == null || !(obj instanceof SchemaNode) || !((SchemaNode)obj).isFromThisSchema(node)) continue;
                return obj;
            }
        }
        return null;
    }

    private SchemaNode getSchemaNode(Node node) {
        Collection collection = this.m_schemaNodes.values();
        if (collection == null) {
            return null;
        }
        Iterator it = collection.iterator();
        if (it == null) {
            return null;
        }
        Object obj = null;
        while (it.hasNext()) {
            obj = it.next();
            if (obj == null || !(obj instanceof SchemaNode) || !((SchemaNode)obj).isFromThisSchema(node)) continue;
            return obj;
        }
        return null;
    }

    class Schema {
        SchemaNode m_schemaNode = null;
        String m_targetNamespace = null;
        Element m_schema = null;
        Hashtable m_elements = new Hashtable();
        Hashtable m_types = new Hashtable();
        Hashtable m_necessaryNamespaces = new Hashtable();

        Schema(SchemaNode schemaNode) {
            Node node;
            Element origSchema = null;
            if (schemaNode != null) {
                this.m_schemaNode = schemaNode;
                node = this.m_schemaNode.getNode();
                if (node != null && node instanceof Element) {
                    origSchema = (Element)node;
                }
            }
            if (origSchema != null && (node = WSMessageSchema.this.m_doc.importNode(origSchema, false)) != null && node instanceof Element) {
                this.m_schema = (Element)node;
                NamedNodeMap attribMap = origSchema.getAttributes();
                if (attribMap != null && attribMap.getLength() > 0) {
                    Node aNode = null;
                    String name = null;
                    String value = null;
                    for (int i = 0; i < attribMap.getLength(); ++i) {
                        aNode = attribMap.item(i);
                        if (aNode == null) continue;
                        name = aNode.getNodeName();
                        value = aNode.getNodeValue();
                        int index = -1;
                        if (name == null || value == null) continue;
                        if (name.compareTo(s_targetNamespace) == 0) {
                            this.m_targetNamespace = value;
                            continue;
                        }
                        index = name.indexOf(s_xmlnsPrefix);
                        if (index != -1) continue;
                        this.m_schema.setAttribute(name, value);
                    }
                }
            }
        }

        private boolean addToSchema(WSDefinedElement element) {
            String elementName = element.getName();
            Node elementNode = element.getDefinedElement().getNode();
            String nodeName = elementNode.getNodeName();
            if (this.m_elements.get(elementName) != null) {
                return true;
            }
            if (!this.m_schemaNode.isFromThisSchema(elementNode)) {
                return false;
            }
            this.addNamespacesToSchema(elementNode);
            Node importedNode = WSMessageSchema.this.m_doc.importNode(elementNode, true);
            this.m_schema.appendChild(importedNode);
            this.m_elements.put(elementName, importedNode);
            IWSTypeEntry typeEntry = element.getRefTypeEntry();
            if (typeEntry != null) {
                if (typeEntry instanceof WSDefinedElement) {
                    this.addToSchema((WSDefinedElement)typeEntry);
                } else if (typeEntry instanceof WSType) {
                    this.addToSchema((WSType)typeEntry);
                }
            }
            return true;
        }

        private void addToSchema(WSType type) {
            if (!type.isBaseType()) {
                Node typeNode = type.getType().getNode();
                String typeName = null;
                if (typeNode != null && typeNode instanceof Element) {
                    typeName = ((Element)typeNode).getAttribute("name");
                }
                if (typeName != null && typeName.length() > 0) {
                    String typeNodeName = typeNode.getNodeName();
                    if (typeNodeName != null && typeNodeName.indexOf("element") != -1 && type.getRefType() != null) {
                        WSMessageSchema.this.addTypeToSchema(type.getRefType());
                        return;
                    }
                    if (this.m_types.get(typeNode) != null) {
                        return;
                    }
                    this.addNamespacesToSchema(typeNode);
                    Node importedNode = WSMessageSchema.this.m_doc.importNode(typeNode, true);
                    this.m_schema.appendChild(importedNode);
                    this.m_types.put(typeNode, importedNode);
                    WSElementDecl[] elementDecls = type.getElementDecls();
                    if (elementDecls != null) {
                        for (int i = 0; i < elementDecls.length; ++i) {
                            if (elementDecls[i] == null) continue;
                            WSMessageSchema.this.addElementToSchema(elementDecls[i]);
                        }
                    }
                    if (type.getRefType() != null) {
                        WSMessageSchema.this.addTypeToSchema(type.getRefType());
                    }
                }
            }
        }

        void addNamespacesToSchema(Node node) {
            if (node != null) {
                NodeList children;
                NamedNodeMap attributes;
                String namespaceURI;
                String prefix;
                int index;
                String name = node.getNodeName();
                String value = node.getNodeValue();
                if (name != null && (index = name.indexOf(":")) != -1 && this.m_necessaryNamespaces.get(prefix = name.substring(0, index)) == null) {
                    namespaceURI = this.m_schemaNode.getNamespace(prefix);
                    if (namespaceURI == null) {
                        namespaceURI = WSMessageSchema.this.m_definition.getNamespace(prefix);
                    }
                    if (namespaceURI != null) {
                        this.m_necessaryNamespaces.put(prefix, namespaceURI);
                        this.m_schema.setAttribute(s_xmlnsPrefix + prefix, namespaceURI);
                    }
                }
                if (value != null && (index = value.indexOf(":")) != -1 && this.m_necessaryNamespaces.get(prefix = value.substring(0, index)) == null) {
                    namespaceURI = this.m_schemaNode.getNamespace(prefix);
                    if (namespaceURI == null) {
                        namespaceURI = WSMessageSchema.this.m_definition.getNamespace(prefix);
                    }
                    if (namespaceURI != null) {
                        this.m_necessaryNamespaces.put(prefix, namespaceURI);
                        this.m_schema.setAttribute(s_xmlnsPrefix + prefix, namespaceURI);
                    }
                }
                if (node.hasAttributes() && (attributes = node.getAttributes()) != null && attributes.getLength() > 0) {
                    Node attribute = null;
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        attribute = attributes.item(i);
                        this.addNamespacesToSchema(attribute);
                    }
                }
                if ((children = node.getChildNodes()) != null && children.getLength() > 0) {
                    Node child = null;
                    for (int i = 0; i < children.getLength(); ++i) {
                        child = children.item(i);
                        this.addNamespacesToSchema(child);
                    }
                }
            }
        }

        void removeNotNeededNamespaces() {
            Enumeration enum1 = this.m_schemaNode.getNamespaces().keys();
            if (enum1 != null) {
                Object obj = null;
                String prefix = null;
                while (enum1.hasMoreElements()) {
                    obj = enum1.nextElement();
                    if (obj == null || !(obj instanceof String) || this.m_necessaryNamespaces.get(prefix = (String)obj) != null || this.m_schema.getAttribute(s_xmlnsPrefix + prefix) == null) continue;
                    this.m_schema.removeAttribute(s_xmlnsPrefix + prefix);
                }
            }
        }

        Element getSchemaElement() {
            this.removeNotNeededNamespaces();
            return this.m_schema;
        }
    }

    class SchemaNode {
        Node m_schemaNode = null;
        String m_targetNamespace = null;
        Hashtable m_attributes = new Hashtable();
        Hashtable m_namespaces = new Hashtable();

        SchemaNode(Node node) {
            NamedNodeMap attribMap;
            this.m_schemaNode = node;
            if (this.m_schemaNode != null && (attribMap = this.m_schemaNode.getAttributes()) != null && attribMap.getLength() > 0) {
                Node aNode = null;
                String name = null;
                String value = null;
                for (int i = 0; i < attribMap.getLength(); ++i) {
                    aNode = attribMap.item(i);
                    if (aNode == null) continue;
                    name = aNode.getNodeName();
                    value = aNode.getNodeValue();
                    int index = -1;
                    if (name == null || value == null) continue;
                    if (name.compareTo(s_targetNamespace) == 0) {
                        this.m_targetNamespace = value;
                        continue;
                    }
                    index = name.indexOf(s_xmlnsPrefix);
                    if (index != -1) {
                        if (name.length() <= index) continue;
                        this.m_namespaces.put(name.substring(index + s_xmlnsPrefix.length()), value);
                        continue;
                    }
                    this.m_attributes.put(aNode.getNodeName(), aNode.getNodeValue());
                }
            }
        }

        boolean isSchemaNode(Node node) {
            String localName = node.getLocalName();
            return localName != null && localName.compareTo("schema") == 0;
        }

        boolean isFromThisSchema(Node node) {
            Node aNode = null;
            do {
                if ((aNode = node.getParentNode()) != null && this.isSchemaNode(aNode)) {
                    return aNode == this.m_schemaNode;
                }
                node = aNode;
            } while (aNode != null);
            return false;
        }

        String getNamespace(String prefix) {
            if (prefix != null) {
                return (String)this.m_namespaces.get(prefix);
            }
            return null;
        }

        String getTargetNamespace() {
            return this.m_targetNamespace;
        }

        boolean isTargetNamespace(String namespace) {
            if (namespace != null && this.m_targetNamespace != null) {
                return namespace.compareTo(this.m_targetNamespace) == 0;
            }
            return false;
        }

        boolean isTargetNamespacePrefix(String prefix) {
            if (prefix != null) {
                return this.isTargetNamespace((String)this.m_namespaces.get(prefix));
            }
            return false;
        }

        Hashtable getNamespaces() {
            return this.m_namespaces;
        }

        Hashtable getAttributes() {
            return this.m_attributes;
        }

        Node getNode() {
            return this.m_schemaNode;
        }
    }
}

